﻿<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.HR" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    
    public enum Zakres {
        Nowe, Zakończone, Ważne, Wszystkie
    }
    
    public class Params : ContextBase {

        public Params(Context context): base(context) {
        }

        DefinicjaElementu[] definicje;
        [Priority(10)]
        public DefinicjaElementu[] Definicje {
            get { return definicje; }
            set {
                definicje = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListDefinicje() {
            return DefElementow.Elementy(this, RodzajŹródłaWypłaty.ZajęcieKomornicze);
        }

        Zakres zakres = Zakres.Ważne;
        [Priority(20)]
        public Zakres Zakres {
            get { return zakres; }
            set {
                zakres = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    [Context]
    public Params Pars {
        set {
            definicje = value.Definicje;
            zakres = value.Zakres;
        }
    }

    [Context(typeof(OkresContext), "Okres")]
    public FromTo Okres {
        set { okres = value; }
    }
    
    DefinicjaElementu[] definicje;
    Zakres zakres;
    FromTo okres;

    RowCondition condition = RowCondition.Empty;

    protected void dc_ContextLoad(object sender, EventArgs e) {

        ReportHeader["UPRAWNIENIA"] = Info("Definicja", "Definicje", definicje);
        ReportHeader["INFO"] = CaptionAttribute.EnumToString(zakres);

        if (definicje != null && definicje.Length > 0)
            condition &= new FieldCondition.In("Element", definicje);

        switch (zakres) {
            case Zakres.Nowe:
                condition &= RowCondition.ContainsIn("Data", okres);
                break;
            case Zakres.Zakończone:
                condition &= RowCondition.ContainsIn("DataSplaty", okres); 
                break;
            case Zakres.Ważne:
                condition &= new FieldCondition.LessEqual("Data", okres.To);
                condition &= new FieldCondition.GreaterEqual("DataSplaty", okres.From); 
                break;
        }

        bool visible = definicje == null || definicje.Length != 1;
        if (!visible)
            colZajęcie.Visible = false;
    }

    protected void Grid_BeforeRow(object sender, RowEventArgs args) {
        Pracownik idx = (Pracownik)args.Row;
        SubTable st = idx.ZajęciaKomornicze;
        st = st[condition];

        bool any = false;
        foreach (ZajęcieKomornicze zk in st) {
            any = true;
            if (zk.Rozliczenie.Odbiorca != null)
                colKomornik.AddLine(zk.Rozliczenie.Odbiorca.Kod);
            else
                colKomornik.AddLine("&nbsp;");
            if (zk.Rodzaj == RodzajeZajęciaWynagrodzenia.Kwota) {
                colStan.AddLine(zk.Kwota);
                colKwota.AddLine("&nbsp;");
            }
            else {
                colStan.AddLine("&nbsp;");
                colKwota.AddLine(zk.Kwota);
            }
            colZajęcie.AddLine(zk.Element.Nazwa);
            colOd.AddLine(zk.Data);
            colDo.AddLine(zk.DataSplaty);
            //decimal wartosc = 0;
            //foreach (WypElement w in zk.Elementy)
            //    wartosc += -w.Wartosc;
            //colSplata.AddLine(wartosc);
            if (zk.Rodzaj == RodzajeZajęciaWynagrodzenia.Kwota) {
                colSplata.AddLine(zk.Kwota-zk.Pozostało);
                colPozostaje.AddLine(zk.Pozostało);
            }
            else {
                colSplata.AddLine("&nbsp;");
                colPozostaje.AddLine("&nbsp;");
            }
			colUwagi.AddLine(zk.Opis);
        }

        args.VisibleRow = any;
    }

    static string Info(string singleLabel, string multiLabel, params object[] lst) {
        if (lst == null || lst.Length == 0)
            return "";
        else if (lst.Length == 1)
            return string.Format("</strong>|{0}: <strong>{1}", singleLabel, lst[0]);
        string info = "";
        foreach (object obj in lst)
            if (info == "")
                info = obj.ToString();
            else
                info += "</strong>, <strong>" + obj.ToString();
        return string.Format("</strong>|{0}: <strong>{1}", multiLabel, info);
    }

    public static void Msg(object value) {
    }
    
</script>

<HTML>
	<HEAD>
		<TITLE>Znajomość języków obcych</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad" 
                Landscape="True"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" 
                title="Zajęcia wynagrodzenia&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;BR&gt;&lt;/strong&gt;Wydział: &lt;strong&gt;{0}&lt;BR&gt;&lt;/strong&gt;Pośrednio: &lt;strong&gt;{1}&lt;BR&gt;&lt;/strong&gt;Okres: &lt;strong&gt;{2}&lt;BR&gt;&lt;/strong&gt;Aktualny: &lt;strong&gt;{3}%UPRAWNIENIA%&lt;BR&gt;&lt;/strong&gt;Zakres: &lt;strong&gt;%INFO%&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;" 
                DataMember0="KadryPracownicyViewInfo+PrParams.Wydział" 
                DataMember1="KadryPracownicyViewInfo+PrParams.Pośrednio" 
                DataMember2="KadryPracownicyViewInfo+PrParams.Okres" 
                DataMember3="KadryPracownicyViewInfo+PrParams.Aktualny"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" 
                RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace" 
                onbeforerow="Grid_BeforeRow">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Pracownik" EncodeHTML="true" Caption="Pracownik"></ea:GridColumn>
				    <ea:GridColumn ID="colKomornik" runat="server" Caption="Komornik" Width="20" NoWrap="true"></ea:GridColumn>
                    <ea:GridColumn ID="colStan" runat="server" Align="Right" Caption="Stan początkowy" Width="11" Format="&amp;nbsp;{0:n}"></ea:GridColumn>
					<ea:GridColumn ID="colKwota" runat="server" Align="Right" Caption="Kwota miesięczna" Width="11" Format="&amp;nbsp;{0:n}"></ea:GridColumn>
				    <ea:GridColumn ID="colZajęcie" runat="server" Caption="Zajęcie wynagrodzenia~Definicja" NoWrap="True" Width="16"></ea:GridColumn>
				    <ea:GridColumn ID="colOd" runat="server" Caption="Zajęcie wynagrodzenia~od dnia" Width="10" Format="{0:b}&amp;nbsp;" NoWrap="True" Align="Center"></ea:GridColumn>
                    <ea:GridColumn ID="colDo" runat="server" Caption="Zajęcie wynagrodzenia~do dnia" Width="10" Format="{0:b}&amp;nbsp;" NoWrap="True" Align="Center"></ea:GridColumn>
                    <ea:GridColumn ID="colSplata" runat="server" Caption="Zajęcie wynagrodzenia~spłacono" Width="12" Format="&amp;nbsp;{0:n}" Align="Right"></ea:GridColumn>
                    <ea:GridColumn ID="colPozostaje" runat="server" Caption="Zajęcie wynagrodzenia~pozostaje" Width="12" Format="&amp;nbsp;{0:n}" Align="Right"></ea:GridColumn>
                    <ea:GridColumn ID="colUwagi" runat="server" Caption="Zajęcie wynagrodzenia~przyczyna" Width="25" Align="Right"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

